<FORWARD>
struct ShaderArgs
{
    int clipPlaneCount;
	float4 clipPlanePositions[5];
	float4 clipPlaneNormals[5];
};
</FORWARD>


<FRAGMENT>
<ARGUMENTS>constant ShaderArgs& shaderArgs [[buffer(2)]]</ARGUMENTS>
<EARLY>
	if( shaderArgs.clipPlaneCount > 0 )
	{
		bool keep = false;
		for( int i = 0; i < shaderArgs.clipPlaneCount && !keep; i++ )
			keep = dot( IN.positionCS - shaderArgs.clipPlanePositions[i].xyz, shaderArgs.clipPlaneNormals[i].xyz ) > 0.0;
		if( !keep )
			discard_fragment();
	}
</EARLY>
</FRAGMENT>
